<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Order extends Model 
{

    protected $table = 'orders';
    public $timestamps = true;
    protected $fillable = array('address_id', 'pay', 'status', 'total');

    public function client()
    {
        return $this->belongsTo('Client');
    }

    public function products()
    {
        return $this->belongsToMany('Product');
    }

    public function address()
    {
        return $this->belongsTo('Address');
    }

}